﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

namespace Curse.CloudSearch
{
    [XmlType("Cluster")]
    public class SearchConfiguration
    {       
        [XmlElement]
        public int RegionIdentifier
        {
            get;
            set;
        }

        [XmlElement]
        public string RegionKey
        {
            get;
            set;
        }

        [XmlArray]
        [XmlArrayItem("Host")]
        public string[] Hosts
        {
            get;
            set;
        }        

        [XmlIgnore]
        public bool IsLocal
        {
            get;
            private set;
        }

        [XmlElement]
        public string Username
        {
            get;
            set;
        }

        [XmlElement]
        public string Password
        {
            get;
            set;
        }

        [XmlArray]
        [XmlArrayItem("TypeName")]
        public string[] Types
        {
            get;
            set;
        }

        public static SearchConfiguration[] Configurations;

        public static SearchConfiguration[] LocalConfigurations
        {
            get;
            private set;
        }

        public static HashSet<int> Regions;

        public static void Initialize(string localRegionIdentifier, IEnumerable<SearchConfiguration> configurations)
        {
            Configurations = configurations.ToArray();
            var localConfigurations = new List<SearchConfiguration>();
            foreach (var config in Configurations)
            {
                if(config.RegionKey == localRegionIdentifier)
                {
                    config.IsLocal = true;
                    localConfigurations.Add(config);                    
                }
            }

            LocalConfigurations = localConfigurations.ToArray();
            Regions = new HashSet<int>(Configurations.Select(p => p.RegionIdentifier));
            if (LocalConfigurations.Count() < 1)
            {
                throw new Exception("You must define at least  one local search configuration element.");
            }


        }
     
    }
}
