﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.CloudSearch
{
    public class TimeSeriesIndexing
    {
        private static readonly string TimeSeriesIndexFormat = "{0}-{1}m{2}";

        public static IEnumerable<DateTime> GetMonthsBetween(DateTime d0, DateTime d1)
        {
            return Enumerable.Range(0, (d1.Year - d0.Year)*12 + (d1.Month - d0.Month + 1))
                .Select(m => new DateTime(d0.Year, d0.Month, 1).AddMonths(m));
        }

        public static string GetIndexName(string indexType, int year, int month)
        {
            return string.Format(TimeSeriesIndexFormat, indexType, year, month.ToString("00"));
        }

        public static string GetIndexName(string indexType, DateTime date)
        {
            return string.Format(TimeSeriesIndexFormat, indexType, date.Year, date.Month.ToString("00"));
        }
    }
}
