﻿using System.Net;
using System.Web.Mvc;

namespace Curse.CloudServices.Authentication.Web.Mvc
{
    public enum AuthenticationLevel
    {
        LoggedIn,
        Anonymous,
        ApiKey
    }

    public class AuthenticationFilter : ActionFilterAttribute
    {
        private readonly AuthenticationLevel _authenticationLevel;

        public AuthenticationFilter(AuthenticationLevel authenticationLevel = AuthenticationLevel.LoggedIn)
        {
            _authenticationLevel = authenticationLevel;
        }

        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            if (AuthenticationContext.Current.IsAnonymous && _authenticationLevel != AuthenticationLevel.Anonymous)
            {
                filterContext.Result = new HttpStatusCodeResult(HttpStatusCode.BadRequest, "Failed authentication");
            }

            base.OnActionExecuting(filterContext);
        }
    }
}