﻿using System.Net;
using System.Net.Http;
using System.Web.Http.Controllers;
using System.Web.Http.Filters;

namespace Curse.CloudServices.Authentication.Web.WebApi
{
    public enum AuthenticationLevel
    {
        LoggedIn,
        Anonymous,
        ApiKey
    }

    public class AuthenticationFilter : ActionFilterAttribute
    {
        private readonly AuthenticationLevel _authenticationLevel;

        public AuthenticationFilter(AuthenticationLevel authenticationLevel = AuthenticationLevel.LoggedIn)
        {
            _authenticationLevel = authenticationLevel;
        }

        public override void OnActionExecuting(HttpActionContext actionContext)
        {
            var token = AuthenticationContext.Current;

            if (token.IsAnonymous && _authenticationLevel != AuthenticationLevel.Anonymous)
            {
                actionContext.Response = new HttpResponseMessage(HttpStatusCode.Forbidden) { Content = new StringContent("{\"error\":\"Failed Authentication\"}") };
            }

            base.OnActionExecuting(actionContext);
        }
    }
}
