﻿
using System;

namespace Curse.CloudServices
{
    public static class AuthenticationConfiguration
    {
        public static string ApiKey
        {
            get;
            set;
        }

        public static bool HasTokenPersistence
        {
            get; private set;
        }

        public static TimeSpan TokenLifespan
        {
            get;
            set;
        }

        public static void SetTokenProvider(IAuthTokenStorageProvider provider)
        {
            AuthTokenStorageProvider = provider;
            HasTokenPersistence = true;
        }

        internal static IAuthTokenStorageProvider AuthTokenStorageProvider;        
    }
}
