﻿using System;
using Curse.ServiceEncryption;

namespace Curse.CloudServices
{
    public class AuthenticationTokenData
    {
        public int UserID { get; set; }
        public string Username { get; set; }        
        public DateTime Timestamp { get; set; }
        public bool IsValid { get; private set; }

        public static AuthenticationTokenData FromToken(EncryptionToken token)
        {
            return new AuthenticationTokenData
            {
                UserID = token.GetInteger("UserID"),
                Username = token.GetValue("Username"),                
                Timestamp = token.GetDateTime("Timestamp"),
                IsValid = true
            };
        }

        public static AuthenticationTokenData FromString(string value)
        {
            var token = EncryptionToken.FromValue(value);         
            return token.IsValid ? FromToken(token) : new AuthenticationTokenData { IsValid = false };
        }
    }
}
