﻿using System;
using System.Net;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Xml;

namespace Curse.CloudServices.Client
{
    public static class BindingHelper
    {

        public static CustomBinding GetBinaryBinding()
        {            
            var binding = new CustomBinding
            {
                CloseTimeout = TimeSpan.FromSeconds(10),
                OpenTimeout = TimeSpan.FromSeconds(10),
                ReceiveTimeout = TimeSpan.FromMinutes(1),
                SendTimeout = TimeSpan.FromMinutes(1)
            };

            // Binary Encoding
            var binaryEncoding = new BinaryMessageEncodingBindingElement
            {
                ReaderQuotas =
                {
                    MaxArrayLength = 16384,
                    MaxBytesPerRead = 4096,
                    MaxNameTableCharCount = 16384,
                    MaxDepth = 64,
                    MaxStringContentLength = 640000
                }
            };

            binding.Elements.Add(binaryEncoding);            
            
            var transport = new HttpsTransportBindingElement();
            
            transport.AuthenticationScheme = AuthenticationSchemes.Anonymous;
            transport.MaxBufferPoolSize = 524288;
            transport.MaxReceivedMessageSize = 2147483647;
            transport.MaxBufferSize = 2147483647;
            transport.AllowCookies = true;
            transport.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            transport.TransferMode = TransferMode.Buffered;

            binding.Elements.Add(transport);            

            return binding;
        }

        private static XmlDictionaryReaderQuotas GetDefaultReaderQuotas()
        {
            var readerQuotas = new XmlDictionaryReaderQuotas
            {
                MaxArrayLength = 16384,
                MaxBytesPerRead = 4096,
                MaxNameTableCharCount = 16384,
                MaxDepth = 64,
                MaxStringContentLength = 640000
            };

            return readerQuotas;
        }       

        public static WSHttpBinding GetSecureWsHttpBinding()
        {
            // Reader quotas
            var readerQuotas = GetDefaultReaderQuotas();

            var binding = new WSHttpBinding(SecurityMode.None, false)
            {
                AllowCookies = false,
                CloseTimeout = TimeSpan.FromSeconds(10),
                OpenTimeout = TimeSpan.FromSeconds(10),
                ReceiveTimeout = TimeSpan.FromMinutes(1),
                SendTimeout = TimeSpan.FromMinutes(1),
                UseDefaultWebProxy = true,
                BypassProxyOnLocal = false,
                TransactionFlow = false,
                HostNameComparisonMode = HostNameComparisonMode.StrongWildcard,
                MaxBufferPoolSize = 524288,
                MaxReceivedMessageSize = 2097152,
                MessageEncoding = WSMessageEncoding.Text,
                TextEncoding = Encoding.UTF8,
                ReaderQuotas = readerQuotas,
                Security =
                {
                    Mode = SecurityMode.Transport,
                    Message =
                    {
                        EstablishSecurityContext = false,
                        ClientCredentialType = MessageCredentialType.None,
                        NegotiateServiceCredential = false
                    }
                }
            };

            // Disable all builtin security
            binding.Security.Transport.ClientCredentialType = HttpClientCredentialType.None;

            return binding;
        }


        public static BasicHttpBinding GetBasicHttpBinding()
        {
            var binding = new BasicHttpBinding
            {
                OpenTimeout = TimeSpan.FromSeconds(10),
                SendTimeout = TimeSpan.FromSeconds(10),
                ReceiveTimeout = TimeSpan.FromSeconds(30),
                CloseTimeout = TimeSpan.FromSeconds(5),                
            };

            binding.Security.Mode = BasicHttpSecurityMode.Transport;                
            binding.Security.Transport.ClientCredentialType = HttpClientCredentialType.None;                

            return binding;
        }
    }
}
