﻿using System;

namespace Curse.CloudServices.Client
{
    public enum ServiceResultStatus
    {
        Successful = 1,
        Fault,
        Communication,
        Exception,
        Security,
    }

    public class ServiceResult<V>
    {
        public ServiceResultStatus Status
        {
            get;
            private set;
        }

        public Exception Exception
        {
            get;
            private set;
        }

        public V Value
        {
            get;
            private set;
        }

        public ServiceResult(V value)
        {
            Value = value;
            Status = ServiceResultStatus.Successful;
        }

        public ServiceResult(ServiceResultStatus status, Exception ex = null)
        {
            Status = status;
            Exception = ex;
        }
    }
}
