﻿using System;

namespace Curse.CloudServices.Jobs
{
    public abstract class BaseJob
    {

        public abstract JobScheduleMode ScheduleMode { get; }
        public abstract void Run();

        public bool ShouldRun(DateTime lastRunTime)
        {
            switch(ScheduleMode)
            {
                case JobScheduleMode.Delegate:
                    return IsScheduled(lastRunTime);

                case JobScheduleMode.Interval:
                    return DateTime.UtcNow.Subtract(lastRunTime).TotalMinutes >= RunFrequencyMinutes;

                default:
                    throw new InvalidOperationException("Unknown schedule mode: " + ScheduleMode);
            }
        }

        public virtual bool IsScheduled(DateTime lastRunTime)
        {
            return false;
        }

        /// <summary>
        ///  Only run this job in the default region.
        /// </summary>
        public virtual bool OnlyDefaultRegion
        {
            get { return false; }
        }

        public virtual int RunFrequencyMinutes
        {
            get
            {
                return Int32.MaxValue;
            }
        }
    }
}
