﻿using Curse.Aerospike;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.CloudServices.Jobs
{
    [TableDefinition(TableName = "JobHistory", ReplicationMode = ReplicationMode.None)]
    public class JobHistory : BaseTable<JobHistory>
    {
        [Column("ID", KeyOrdinal = 1, IsIndexed = true)]
        public Guid ID
        {
            get;
            set;
        }

        [Column("JobName", IsIndexed = true)]
        public string JobName
        {
            get;
            set;
        }

        [Column("DateStarted")]
        public DateTime DateStarted
        {
            get;
            set;
        }

        [Column("DateCompleted")]
        public DateTime DateCompleted
        {
            get;
            set;
        }

        [Column("Duration")]
        public long DurationMilliseconds
        {
            get;
            set;
        }

        [Column("Status")]
        public JobRunStatus Status
        {
            get;
            set;
        }

        [Column("StatusMessage")]
        public string StatusMessage
        {
            get;
            set;
        }

        [Column("HostName")]
        public string HostName
        {
            get;
            set;
        }
    }
}
