﻿using Curse.Aerospike;
using System;

namespace Curse.CloudServices.Jobs
{
    [TableDefinition(TableName = "JobInfo", ReplicationMode = ReplicationMode.None)]
    public class JobInfo : BaseTable<JobInfo>
    {
        [Column("Name", KeyOrdinal = 1, IsIndexed = true)]
        public string Name
        {
            get;
            set;
        }

        [Column("ScheduleMode")]
        public JobScheduleMode ScheduleMode
        {
            get;
            set;
        }
                       
        [Column("CurrentRunner")]
        public string CurrentRunner
        {
            get;
            set;
        }

        [Column("LastRunTime")]
        public DateTime LastRunTime
        {
            get;
            set;
        }

        [Column("IndexMode", IsIndexed = true)]
        public IndexMode IndexMode
        {
            get;
            set;
        }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

    }
}
