﻿using System;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;

namespace Curse.CloudServices.Models
{
    [DataContract(Namespace = HeaderNamespace)]
    public sealed class AuthenticationToken
    {
        public const string HeaderName = "AuthenticationToken";
        public const string HeaderNamespace = "urn:Curse.FriendsService:v1";
        public const string HttpHeaderName = "AuthenticationToken";
        public const string LegacyHttpHeaderName = "X-Auth-Token";
        public const string HttpCookieName = "CurseAuthToken";

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public int UserID { get; set; }

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public string Token { get; set; }
        
        public string Username { get; set; }
        
      
        [DataMember]
        public string ApiKey { get; set; }

        public bool HasPremium { get; set; }

        public bool IsAnonymous
        {
            get;
            set;
        }

        public bool IsInvalid
        {
            get;
            set;
        }

        public bool IsApiRequest
        {
            get;
            set;
        }

        public bool IsFromCookie
        {
            get;
            set;
        }

        private static readonly TimeSpan TokenGracePeriod = TimeSpan.FromMinutes(5);

        public long ValidThrough { get; private set; }

        private long _issuedTimestamp;

        public long IssuedTimestamp
        {
            get { return _issuedTimestamp; }
            set
            {
                _issuedTimestamp = value;
                ValidThrough = value + (long) TokenGracePeriod.TotalMilliseconds;
            }
        }     

        public static AuthenticationToken FromHeaders(int userID)
        {
            return new AuthenticationToken()
            {
                UserID = userID,                
            };
        }

        public static void Initialize(int userID, string token, string apiKey = null)
        {
            _outgoing = new AuthenticationToken()
            {
                UserID = userID,
                Token = token,
                ApiKey = apiKey
            };
        }

        private static AuthenticationToken _outgoing;

        // These are the values owned by the client's current
        // thread, that will be passed to the service.
        public static AuthenticationToken Outgoing
        {
            get
            {
                return _outgoing;
            }
            set
            {
                _outgoing = value;
            }
        }
    }

    public sealed class AuthTokenExtension : IEndpointBehavior, IClientMessageInspector
    {        

        object IClientMessageInspector.BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            var messageHeader = MessageHeader.CreateHeader(AuthenticationToken.HeaderName, AuthenticationToken.HeaderNamespace, AuthenticationToken.Outgoing);
            request.Headers.Add(messageHeader);
            return null;

        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new AuthTokenExtension());
        }

        void IClientMessageInspector.AfterReceiveReply(ref Message reply, object correlationState)
        {
            // Do nothing
        }

        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            // Do nothing
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
            // Do nothing
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            // Do nothing
        }
    }
}
