﻿using System;
using System.ServiceModel.Dispatcher;
using Newtonsoft.Json;

namespace Curse.CloudServices.Wcf.Json
{
    public class NetwonSoftJsonQueryStringConverter : QueryStringConverter
    {
        public override object ConvertStringToValue(string parameter, Type parameterType)
        {
            return JsonConvert.DeserializeObject(parameter, parameterType);
        }

        public override string ConvertValueToString(object parameter, Type parameterType)
        {
            return JsonConvert.SerializeObject(parameter);
        }

        public override bool CanConvert(Type type)
        {
            return true;
        }
    }
}
