﻿using System;
using System.Configuration;
using System.ServiceModel.Configuration;

namespace Curse.CloudServices.Wcf.Json
{
    public class NewtonsoftJsonBehaviorExtension : BehaviorExtensionElement
    {
        private const string HelpEnabledPropertyName = "HelpEnabled";
        private const string FaultExceptionEnabledPropertyName = "FaultExceptionEnabled";

        [ConfigurationProperty(HelpEnabledPropertyName, DefaultValue = false)]
        public bool HelpEnabled
        {
            get { return (bool) base[HelpEnabledPropertyName]; }
            set { base[HelpEnabledPropertyName] = value; }
        }

        [ConfigurationProperty(FaultExceptionEnabledPropertyName, DefaultValue = false)]
        public bool FaultExceptionEnabled
        {
            get { return (bool)base[FaultExceptionEnabledPropertyName]; }
            set { base[FaultExceptionEnabledPropertyName] = value; }
        }

        public override Type BehaviorType
        {
            get { return typeof(NewtonsoftJsonBehavior); }
        }

        protected override object CreateBehavior()
        {
            return new NewtonsoftJsonBehavior
            {
                HelpEnabled = HelpEnabled,
                FaultExceptionEnabled = FaultExceptionEnabled
            };
        }
    }
}
