﻿using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.AccountsWebService.Configuration
{

    [XmlRoot("Service")]
    public class AccountsWebServiceConfiguration
    {
        public static readonly AccountsWebServiceConfiguration Current;

        static AccountsWebServiceConfiguration()
        {
            Current = ConfigurationHelper.LoadConfiguration<AccountsWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "AccountsWebServiceConfiguration");
        }

        [XmlElement("AuthenticationServiceUrl")]
        public string AuthenticationServiceUrl { get; set; }

        [XmlElement("AuthenticationServiceSiteID")]
        public int AuthenticationServiceSiteID { get; set; }

        [XmlElement("AuthenticationServiceSiteKey")]
        public string AuthenticationServiceSiteKey { get; set; }

        [XmlElement("PremiumPromoThrough")]
        public long PremiumPromoThrough { get; set; }


    }
}