﻿using Curse.Extensions;
using Curse.Friends.MicroService;
using Curse.Logging;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class AccountRenameRequest : BaseRequestContract
    {
        public string Username { get; set; }

        protected override bool DoValidate()
        {
            if (!Username.SafeRange(4, 32))
            {
                Logger.Warn("Request to rename account with an invalid username", new { Username = Username ?? "<NULL>" } );
                return false;
            }

            return true;
        }
    }
}