﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangeClientSettingsRequest : BaseRequestContract
    {
        public string GlobalSettings { get; set; }

        public string WebSettings { get; set; }

        public string DesktopSettings { get; set; }

        public string MobileSettings { get; set; }
        
        protected override bool DoValidate()
        {
            if (GlobalSettings == null && WebSettings == null && DesktopSettings == null)
            {
                _validationMessage = "Request has no changed settings";
                return false;
            }

            return true;
        }
    }
}