﻿using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangeGameStatusRequest : BaseRequestContract
    {
        public int GameID
        {
            get;
            set;
        }

        public int GameState
        {
            get;
            set;
        }

        public string GameStatusMessage
        {
            get;
            set;
        }

        public bool IsRunning
        {
            get;
            set;
        }

        public string MachineKey
        {
            get; 
            set;
        }

        protected override bool DoValidate()
        {
            if (GameStatusMessage != null && GameStatusMessage.Length > User.CurrentGameStatusMessageMaxLength)
            {
                _validationMessage = "Game status cannot exceed " + User.CurrentGameStatusMessageMaxLength + " characters";
                return false;
            }

            if (IsRunning && GameID <= 0)
            {
                _validationMessage = "Game ID must be a valid number when is running is true.";
                return false;
            }

            if (!IsRunning && GameID != 0)
            {
                _validationMessage = "Game ID must be 0 when is running is true.";
                return false;
            }
            
            if (string.IsNullOrWhiteSpace(MachineKey))
            {
                _validationMessage = "MachineKey cannot be empty";
                return false;
            }

            return true;
        }
    }
}