﻿using Curse.Friends.AuthenticationClient;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangePasswordRequest
    {
        public string OldPassword { get; set; }
        public string NewPassword { get; set; }
        public string ConfirmNewPassword { get; set; }


        public ChangePasswordStatus Validate()
        {
            if (!AuthenticationValidation.IsValidPassword(OldPassword))
            {
                return ChangePasswordStatus.InvalidOldPassword;
            }

            if (!AuthenticationValidation.IsValidPassword(NewPassword) || !AuthenticationValidation.IsValidPassword(ConfirmNewPassword))
            {
                return ChangePasswordStatus.InvalidNewPassword;
            }

            if (!NewPassword.Equals(ConfirmNewPassword))
            {
                return ChangePasswordStatus.PasswordMismatch;
            }

            return ChangePasswordStatus.Success;
        }
    }
}