﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangeProfileRequest : BaseRequestContract
    {       
        public string Name
        {
            get;
            set;
        }                

        public string City
        {
            get;
            set;
        }

        public string State
        {
            get;
            set;
        }
        
        public string CountryCode
        {
            get;
            set;
        }
        
        public string AboutMe
        {
            get;
            set;
        }

        protected override bool DoValidate()
        {           

            if (Name.SafeLength() > User.NameMaxLength)
            {
                _validationMessage = "Name cannot exceed " + User.NameMaxLength + " characters";
                return false;
            }

            if (City.SafeLength() > User.CityMaxLength)
            {
                _validationMessage = "City cannot exceed " + User.CityMaxLength + " characters";
                return false;
            }

            if (State.SafeLength() > User.StateMaxLength)
            {
                _validationMessage = "State cannot exceed " + User.StateMaxLength + " characters";
                return false;
            }

            if (CountryCode.SafeLength() > User.CountryCodeMaxLength)
            {
                _validationMessage = "CountryCode cannot exceed " + User.CountryCodeMaxLength + " characters";
                return false;
            }

            if (AboutMe.SafeLength() > User.AboutMeMaxLength)
            {
                _validationMessage = "AboutMe cannot exceed " + User.AboutMeMaxLength + " characters";
                return false;
            }

            return true;
        }
    }
}