﻿using System;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangeStatusRequest : BaseRequestContract
    {
        public Guid MachineKey
        {
            get;
            set;
        }

        public UserConnectionStatus Status
        {
            get;
            set;
        }

        public string CustomStatusMessage
        {
            get;
            set;
        
        }

        protected override bool DoValidate()
        {
            if (Status == UserConnectionStatus.Offline)
            {
                _validationMessage = "User cannot change their status to offline manually.";
                return false;
            }

            if (MachineKey == Guid.Empty)
            {
                _validationMessage = "MachineKey must be a valid Guid";
                return false;
            }

            if (CustomStatusMessage != null && CustomStatusMessage.Length > Friendship.CustomStatusMaxLength)
            {
                _validationMessage = "Custom status messages cannot exceed " + CustomStatusMessage.Length + " characters";
                return false;
            }

            return true;
        }
    }
}