﻿using Curse.Extensions;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class ChangeWatchingStatusRequest : BaseRequestContract
    {
        public string ChannelID { get; set; }
        public string MachineKey { get; set; }
        public bool IsWatching { get; set; }

        protected override bool DoValidate()
        {
            
            if (IsWatching && !ChannelID.IsNumeric())
            {
                _validationMessage = "ChannelID must be a numeric value.";
                return false;
            }

            if (string.IsNullOrWhiteSpace(MachineKey))
            {
                _validationMessage = "MachineKey cannot be empty";
                return false;
            }
           
            return true;
        }
    }
}