﻿using System.Collections.Generic;
using Curse.Friends.Data;

namespace Curse.Friends.AccountsWebService.Contracts
{
    public class GetEmotesResponse
    {
        public Dictionary<int, EmoteContract[]> EmoteGroups { get; set; }
    }

    public class EmoteContract
    {
        public long EmoteID { get; set; }

        public long EmoteSet { get; set; }

        public string Text { get; set; }

        public string Url { get; set; }
        public int EmoteHeight { get; set; }
        public int EmoteWidth { get; set; }

        public static EmoteContract ToContract(TwitchEmote emoticon, string urlFormat)
        {
            return new EmoteContract
            {
                EmoteID = emoticon.EmoteID,
                Text = emoticon.Regex,
                Url = string.Format(urlFormat, "twitch-emotes", emoticon.EmoteID),
                EmoteSet = emoticon.EmoticonSet,
                EmoteHeight = emoticon.Height,
                EmoteWidth = emoticon.Width,
            };
        }
    }
}