﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using Curse.Friends.Data;
using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.AccountsWebService.Contracts;
using Curse.Friends.Data.Models;
using Curse.Logging;

namespace Curse.Friends.AccountsWebService.Controllers
{
#if !DEBUG
    [ApiExplorerSettings(IgnoreApi = true)]
#endif
    [RoutePrefix("account/api")]
    [AuthenticationFilter(AuthenticationLevel.ApiKey)]
    public class AccountApiController : ApiController
    {
        private static readonly LogCategory Logger = new LogCategory("AccountApiController");

        [Route("{userID}/rename")]
        [HttpPost]
        [ResponseType(typeof (void))]
        public IHttpActionResult AccountRename(int userID, AccountRenameRequest renameRequest)
        {
            
            // Get the user by region                        
            var userRegion = UserRegion.GetByUserID(userID);
            if (userRegion == null)
            {
                Logger.Warn("Attempted to rename a user that has no user region");
                return BadRequest("Unknown user: " + userID);
            }

            var user = userRegion.GetUser();

            Logger.Info("Received a rename request for user: " + user.Username, renameRequest);

            user.ChangeUsername(renameRequest.Username);

            return Ok();
        }
    }
}