﻿using Curse.Friends.AccountsWebService.Authentication;
using Curse.Friends.AccountsWebService.Configuration;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.AccountsWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.AccountsWebService;}
        }

        protected override string ServiceDescription
        {
            get { return "The accounts service provides functionality for managing an authenticated user's account settings, preferences and profile."; }
        }
      

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database | ConfigurationServices.Queue | ConfigurationServices.TwitchApi; }
        }

        protected override void CustomApplicationStartup()
        {
            AccountsAuthenticationProvider.Initialize(
                AccountsWebServiceConfiguration.Current.AuthenticationServiceUrl, 
                AccountsWebServiceConfiguration.Current.AuthenticationServiceSiteID,
                AccountsWebServiceConfiguration.Current.AuthenticationServiceSiteKey);
        }
    }
}
