﻿using System;
using System.Net.Mail;
using Curse.Extensions;

namespace Curse.Friends.AuthenticationClient
{
    public static class AuthenticationValidation
    {
        public static bool IsValidUsername(string username)
        {
            return username.SafeRange(1, 32);
        }

        public static bool IsValidPassword(string password)
        {
            return password.SafeRange(6, 32);
        }

        public static bool IsValidEmail(string email)
        {
            try
            {                
                var m = new MailAddress(email);
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}
