﻿using System;
using System.Collections.Generic;
using System.Globalization;
using Curse.ServiceEncryption;

namespace Curse.Friends.AuthenticationClient
{
    public static class EncryptionTokenHelper
    {
        public static DateTime GetExpiration(this EncryptionToken token, TimeSpan tokenDuation)
        {
            return token.GetDateTime("Timestamp") + tokenDuation;
        }

        public static DateTime GetTimestamp(this EncryptionToken token)
        {
            return token.GetDateTime("Timestamp");
        }

        public static bool IsExpired(this EncryptionToken token, TimeSpan tokenDuation)
        {
            return token.GetDateTime("Timestamp") + tokenDuation < DateTime.UtcNow;
        }

        public static bool IsRenewable(this EncryptionToken token, TimeSpan tokenDuation, TimeSpan renwalWindow)
        {
            if (token.IsExpired(tokenDuation))
            {
                return false;            
            }

            var age = DateTime.UtcNow - token.GetDateTime("Timestamp");

            return age > renwalWindow;
        }

        public static EncryptionToken Create(int userID, string username, string email, DateTime timestamp)
        {
            return EncryptionToken.FromDictonary(new Dictionary<string, string>
            {
                {"UserID", userID.ToString(CultureInfo.InvariantCulture)},
                {"Username", username},
                {"Email", email},
                {"Timestamp", EncryptionToken.ConvertToEpoch(timestamp).ToString(CultureInfo.InvariantCulture)},
            });
        }

        public static EncryptionToken Renew(this EncryptionToken token, DateTime timestamp)
        {
            var userID = token.GetInteger("UserID");
            var username = token.GetValue("Username");
            var email = token.GetValue("Email");
            return Create(userID, username, email, timestamp);
        }
    }
}