﻿using System;
using Curse.CloudServices.Authentication.Web;
using Curse.Friends.AvatarsWebService.Configuration;
using Curse.Friends.Configuration;

namespace Curse.Friends.AvatarsWebService
{
    public class AvatarManager
    {
        public static DomainWhitelist Whitelist;

        public static void Initialize()
        {
            ImageManager.ImageManager.Initialize();

            var config = ConfigurationHelper.LoadConfiguration<AvatarServiceConfiguration>(FriendsServiceConfiguration.Mode, "AvatarService");

            if (config == null)
            {
                throw new Exception("Failed to initialize. No local config is defined!");
            }

            AvatarServiceConfiguration.Current = config;
            Whitelist = new DomainWhitelist(config.DomainWhitelist);
        }        
    }
}