﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Configuration;
using Curse.Friends.Data;

namespace Curse.Friends.AvatarsWebService.Contract
{
    public class FindUserAvatarSearchResult : GetAvatarResult
    {
        public int UserID { get; set; }

        public string Username { get; set; }

        public string AvatarUrl { get; set; }

        public static FindUserAvatarSearchResult Create(int userID, string username, Avatar avatar)
        {
            var result = new FindUserAvatarSearchResult
            {
                UserID = userID,
                Username = username,
                AvatarUrl = string.Format(FriendsServiceConfiguration.Instance.AvatarUrlFormat, "users", userID)
            };

            if (avatar != null)
            {
                result.SetAvatarInfo(avatar);
            }

            return result;
        }
    }
}