﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.AvatarsWebService.Contract
{
    public class GetAvatarResult
    {
        public string EntityID { get; set; }

        public AvatarType Type { get; set; }

        public bool IsMarkedInappropriate { get; set; }

        public string FileID { get; set; }

        public string Filename { get; set; }

        public string FileUrl { get; set; }

        public int FileRegion { get; set; }

        public long Timestamp { get; set; }

        public static GetAvatarResult FromAvatar(Avatar avatar)
        {
            var result = new GetAvatarResult();
            result.SetAvatarInfo(avatar);
            return result;
        }

        protected void SetAvatarInfo(Avatar avatar)
        {
            EntityID = avatar.EntityID;
            Type = (AvatarType) avatar.AvatarType;
            FileID = avatar.StorageKey;
            Filename = avatar.Filename;
            FileUrl = avatar.Url;
            IsMarkedInappropriate = avatar.IsInappropriate;
            FileRegion = avatar.FileRegionID;
            Timestamp = avatar.Timestamp;
        }
    }
}