﻿using Curse.CloudFlare;
using Curse.Friends.AvatarsWebService.Configuration;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.AvatarsWebService
{
    public class MvcApplication : MicroServiceApplication
    {
        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.All; }
        }

        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.AvatarService; }
        }

        protected override string ServiceDescription
        {
            get { return "The avatar service manages avatars, icons, emoticons, etc., that are associated to Curse resources."; }
        }

        protected override void CustomApplicationStartup()
        {
            AvatarManager.Initialize();
            if (AvatarServiceConfiguration.Current.CloudFlareEnabled)
            {
                CloudFlareApi.Initialize(AvatarServiceConfiguration.Current.CloudFlareApiKey, AvatarServiceConfiguration.Current.CloudFlareEmail);
            }
        }
    }
}
