﻿using System.Xml.Serialization;
using Curse.Friends.BattleNet;
using Curse.Friends.Configuration;

namespace Curse.Friends.BattleNetService.Configuration
{
    [XmlRoot("BattleNet")]
    public class BattleNetServiceConfiguration
    {
        private static readonly BattleNetServiceConfiguration _instance;

        public static BattleNetServiceConfiguration Instance { get { return _instance; } }

        static BattleNetServiceConfiguration()
        {
            _instance = ConfigurationHelper.LoadConfiguration<BattleNetServiceConfiguration>(FriendsServiceConfiguration.Mode, "BattleNet");
        }

        [XmlElement]
        public BattleNetApplication Application { get; set; }
    }
}
