﻿using Curse.Friends.Configuration;
using Curse.Friends.ServerHosting;

namespace Curse.Friends.BattleNetService
{
    public partial class CurseBattleNetService : CurseWindowsService
    {
        public CurseBattleNetService()
        {
            InitializeComponent();
        }

        protected override ServiceHostType HostType
        {
            get { return ServiceHostType.BattleNetService; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database | ConfigurationServices.Queue; }
        }

        protected override void CustomStartup()
        {
            BattleNetServer.StartServer();
        }

        protected override void CustomStop()
        {
            BattleNetServer.StopServer();
        }
    }
}
