﻿using System;
using System.ServiceProcess;

namespace Curse.Friends.BattleNetService
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main()
        {
#if DEBUG
            Console.Write("Starting BattleNet Worker...");
            var service = new CurseBattleNetService();
            service.OnDebugStart();
            Console.WriteLine("Done");
            
            Console.ReadLine();

            Console.Write("Shutting down BattleNet Worker...");
            service.OnDebugStop();
            Console.WriteLine("Done");

#else
            ServiceBase[] ServicesToRun;
            ServicesToRun = new ServiceBase[] 
            { 
                new CurseBattleNetService() 
            };
            ServiceBase.Run(ServicesToRun);
#endif
        }
    }
}
