﻿using System;
using Curse.Friends.BattleNet;
using Curse.Friends.Data;
using Curse.Friends.Data.DerivedModels;
using Curse.Friends.Enums;

namespace Curse.Friends.BattleNetService
{
    public class WowGuildSession
    {
        private readonly ExternalGuild _cachedGuild;

        public WowGuildSession(ExternalGuildIdentifier info, int bucket)
        {
            GuildInfo = info;
            _cachedGuild = ExternalGuild.Get(info);
            if (_cachedGuild == null)
            {
                throw new DataNotFoundException();
            }
            Bucket = bucket;
        }

        public void Shutdown(string newHost = null)
        {
            _cachedGuild.MachineName = newHost ?? string.Empty;
            _cachedGuild.Update(g => g.MachineName);
        }

        public int Bucket { get; private set; }

        public ExternalGuildIdentifier GuildInfo { get; private set; }

        #region Periodic Tasks

        private DateTime? _dateLastGuildSync;

        public void RunBucketedTasks()
        {
            if (!_dateLastGuildSync.HasValue || DateTime.UtcNow - _dateLastGuildSync.Value > TimeSpan.FromHours(2))
            {
                SyncGuild();
            }
        }

        public void SyncGuild()
        {
            var freshGuild = ExternalGuild.Get(GuildInfo);
            if (freshGuild == null)
            {
                return;
            }

            if (DateTime.UtcNow - freshGuild.DateLastSynced < TimeSpan.FromHours(2))
            {
                return;
            }

            _dateLastGuildSync = DateTime.UtcNow;

            if (BattleNetModelHelper.UpdateGuild(freshGuild))
            {
                ExternalGuildMemberSyncWorker.Create(AccountType.WorldOfWarcraft, freshGuild.GetGuildInfo());
            }
        }

        #endregion
    }
}
