﻿using System;
using System.Data.SqlClient;
using Curse.Friends.Enums;
using Curse.Logging;
using Curse.Friends.BugsWebService.Contracts;
using Curse.Friends.BugsWebService.Configuration;

namespace Curse.Friends.BugsWebService
{
    public class ClientVersionHelper
    {
        public static bool CreateControlPanelClientVersion(string versionString, DevicePlatform platform, ReleaseType releaseType)
        {
            return CreateVersion(BugsWebServiceConfiguration.Current.DatabaseConnectionString, "ClientVersion", versionString, platform, releaseType);
        }

        private static bool CreateVersion(string connectionString, string tableName, string versionString, DevicePlatform platform, ReleaseType releaseType)
        {
            using (var conn = new SqlConnection(connectionString))
            {
                try
                {
                    conn.Open();
                    using (var cmd = conn.CreateCommand())
                    {
                        cmd.CommandText = $"SELECT TOP 1 ID FROM [{tableName}] WHERE VersionString = @VersionString";
                        cmd.Parameters.AddWithValue("@Type", (byte)releaseType);
                        cmd.Parameters.AddWithValue("@VersionString", versionString);
                        cmd.Parameters.AddWithValue("@Platform", (byte)platform);

                        var result = cmd.ExecuteScalar();
                        if (result != null && result != DBNull.Value)
                        {
                            cmd.CommandText = $"UPDATE [{tableName}] SET DateReleased = GETUTCDATE(), Type = @Type WHERE VersionString = @VersionString";
                        }
                        else
                        {
                            cmd.CommandText = $"INSERT INTO [{tableName}] (Type, VersionString, Platform) Values(@Type, @VersionString, @Platform)";
                        }

                        return cmd.ExecuteNonQuery() > 0;
                    }
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, $"Failed to save {tableName} in DB {conn.Database}");
                    return false;
                }
            }
        }
    }
}