﻿using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.S3;

namespace Curse.Friends.BugsWebService.Configuration
{

    [XmlRoot("Service")]
    public class BugsWebServiceConfiguration
    {
        private static BugsWebServiceConfiguration _current;
        public static BugsWebServiceConfiguration Current
        {
            get
            {
                if (_current == null)
                {
                    _current = ConfigurationHelper.LoadConfiguration<BugsWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "BugsWebServiceConfiguration");
                }

                return _current;
            }
        }

        [XmlElement("DatabaseConnectionString")]
        public string DatabaseConnectionString { get; set; }

        [XmlElement("MaxQueueSize")]
        public int MaxQueueSize { get; set; }

        [XmlElement("ProcessGameCrashes")]
        public bool ProcessGameCrashes { get; set; }

        [XmlElement("Bucket")]
        public S3BucketConfiguration Bucket { get; set; }

        [XmlElement("MongooseBaseUrl")]
        public string MongooseBaseUrl { get; set; }
        [XmlElement("DatabaseShutoff")]
        public bool DatabaseShutoff { get; set; }
    }
}