﻿using Curse.Friends.Enums;
using System;
using System.Linq;
using Curse.Friends.MicroService;

namespace Curse.Friends.BugsWebService.Contracts
{
    public class BugReport : BaseRequestContract
    {
        protected override bool DoValidate()
        {
            Version version;
            if (!Version.TryParse(ClientVersion, out version))
            {
                _validationMessage = "ClientVersion";
                return false;
            }
            
            if (string.IsNullOrEmpty(Title))
            {
                _validationMessage = "Title";
                return false;
            }

            if (Attachments != null)
            {
                if (Attachments.Length > 10)
                {
                    _validationMessage = "Attachments Count";
                    return false;
                }

                if (Attachments.Any(p => p.FileContents.Length > 1048576))
                {
                    _validationMessage = "Attachments File Size";
                    return false;
                }
            }

            return true;
        }

        public string ClientVersion
        {
            get;
            set;
        }

        public string Title
        {
            get;
            set;
        }
        
        public BugReportType Type
        {
            get;
            set;
        }
        
        public Int64? StackTraceHash
        {
            get;
            set;
        }

        public string UserSettings
        {
            get;
            set;
        }

        public string SystemInformation
        {
            get;
            set;
        }

        public string IncompatibleProcesses
        {
            get;
            set;
        }

        public string GameConfiguration
        {
            get;
            set;
        }

        public string LogData
        {
            get;
            set;
        }

        public BugReportAttachment[] Attachments
        {
            get;
            set;
        }

        public string ExceptionDetails
        {
            get;
            set;
        }

        public string ApplicationLocation
        {
            get;
            set;
        }

        public string Message
        {
            get;
            set;
        }

        public int? LastAttemptedVoiceHostID
        {
            get;
            set;
        }

        public int? OverlayExitCode
        {
            get;
            set;
        }

        public byte? OverlayGameState
        {
            get;
            set;
        }

        public BugReportProcess[] RunningProcesses { get; set; }

        public DevicePlatform Platform { get; set; }

        public int? CallQuality { get; set; }

        public string TimeConfiguration { get; set; }
    }
}