﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;
using Curse.Friends.BugsWebService.Models;

namespace Curse.Friends.BugsWebService.Contracts
{
    public class ClientBugReportAttachmentContract
    {
        public int AttachmentID { get; set; }

        public int BugReportID { get; set; }

        public string Filename { get; set; }

        public long FileLength { get; set; }

        public byte[] FileContents { get; set; }

        public long CreatedTimestamp { get; set; }

        public ClientBugReportAttachmentContract()
        {
            
        }

        public ClientBugReportAttachmentContract(ClientBugReportAttachment attachment)
        {
            AttachmentID = attachment.AttachmentID;
            BugReportID = attachment.ReportID;
            Filename = attachment.Filename;
            FileLength = attachment.FileLength;
            FileContents = attachment.FileContents;
            CreatedTimestamp = attachment.DateCreated.ToEpochMilliseconds();
        }
    }
}