﻿using System;
using Curse.Extensions;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.BugsWebService.Contracts
{
    public class Feedback : BaseRequestContract
    {
        protected override bool DoValidate()
        {
            Version version;
            if (!Version.TryParse(ClientVersion, out version))
            {
                _validationMessage = "ClientVersion";
                return false;
            }

            if (!Message.SafeRange(0, 3000))
            {
                _validationMessage = "Message";
                return false;
            }

            if (!LogData.SafeRange(0, 100000))
            {
                _validationMessage = "LogData";
                return false;
            }

            return true;
        }

        public FeedbackType FeedbackType { get; set; }
        public string ClientVersion { get; set; }
        public DevicePlatform Platform { get; set; }
        public string LogData { get; set; }
        public string Message { get; set; }
        public int? LastAttemptedVoiceHostID { get; set; }
    }
}