﻿
using System;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Extensions;

namespace Curse.Friends.BugsWebService.Contracts
{
    public enum ReleaseType
    {
        Debug = 1,
        Alpha = 2,
        Beta = 3,
        Release = 4
    }

    public class RegisterVersionRequest : BaseRequestContract
    {
        public string ApiKey { get; set; }
        public string VersionString { get; set; }
        public DevicePlatform Platform { get; set; }
        public ReleaseType ReleaseType { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrWhiteSpace(VersionString))
            {
                _validationMessage = "Missing version";
                return false;
            }

            return true;
        }
    }
}