﻿using Curse.Extensions;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.BugsWebService.Contracts
{
    public class UserReport : BaseRequestContract
    {
        public UserReportType Type { get; set; }
        public UserReportReason Reason { get; set; }
        public int UserID { get; set; }
        public string Description { get; set; }
        
        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(Description))
            {
                _validationMessage = "Description is required."; 
                return false;
            }

            if (Description.SafeLength() > 16777215)
            {
                _validationMessage = "Description is too long.";
                return false;
            }

            if (UserID <= 0)
            {
                _validationMessage = "UserID is required";
                return false;
            }

            return true;
        }
    }
}