﻿using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Web.Http;
using System.Web.Http.Description;
using Curse.Friends.BugsWebService.Contracts;
using Curse.Friends.BugsWebService.Models;
using Curse.Friends.MicroService;
using Curse.Friends.BugsWebService.Configuration;

namespace Curse.Friends.BugsWebService.Controllers
{
    [RoutePrefix("bugs/api")]
    [AuthenticationFilter(AuthenticationLevel.ApiKey)]
    public class BugsApiController : MicroServiceController
    {
        [HttpGet]
        [Route("attachments/{attachmentID}")]
        [ResponseType(typeof(Stream))]
        public IHttpActionResult DownloadAttachment(int attachmentID)
        {
            if (BugsWebServiceConfiguration.Current.DatabaseShutoff)
            {
                return NotFound();
            }

            var attachment = ClientBugReportAttachment.GetByID(attachmentID);
            if (attachment == null)
            {
                return NotFound();
            }

            var message = Request.CreateResponse(HttpStatusCode.OK);
            var memoryStream = new MemoryStream(attachment.FileContents);
            message.Content = new StreamContent(memoryStream);
            message.Content.Headers.ContentType = new MediaTypeHeaderValue("application/octet-stream");
            message.Content.Headers.ContentDisposition = new ContentDispositionHeaderValue("attachment") {FileName = attachment.Filename};
            return ResponseMessage(message);
        }

        [HttpGet]
        [Route("reports/{bugReportID}/attachments")]
        [ResponseType(typeof (IEnumerable<ClientBugReportAttachmentContract>))]
        public IHttpActionResult GetReportAttachments(int bugReportID)
        {
            if (BugsWebServiceConfiguration.Current.DatabaseShutoff)
            {
                return NotFound();
            }
            var attachments = ClientBugReportAttachment.GetAttachmentsForReport(bugReportID);
            return Ok(attachments.Select(a => new ClientBugReportAttachmentContract(a)));
        }
    }
}