﻿using System.Net;
using System.Web.Http;
using System.Web.Http.Description;
using Curse.Friends.MicroService;
using Curse.Friends.Configuration;
using Curse.Friends.BugsWebService.Contracts;

namespace Curse.Friends.BugsWebService.Controllers
{
    [RoutePrefix("client-version")]
#if !CONFIG_DEBUG && !CONFIG_STAGING
    [ApiExplorerSettings(IgnoreApi = true)]
#endif
    [AuthenticationFilter(AuthenticationLevel.Anonymous)]
    public class ClientVersionController : MicroServiceController
    {
        [Route("")]
        [HttpPost]
        public IHttpActionResult RegisterClientVersion(RegisterVersionRequest request)
        {
            request.Validate();

            if(request.ApiKey != FriendsServiceConfiguration.Instance.CentralServiceApiKey)
            {
                return ErrorResponse(HttpStatusCode.Forbidden, "bad_api_key", "API key missing or incorrect");
            }

            if (!ClientVersionHelper.CreateControlPanelClientVersion(request.VersionString, request.Platform, request.ReleaseType))
            {
                return ErrorResponse(HttpStatusCode.InternalServerError, "cp_update_failed", "Failed to update CP Database");
            }

            return Ok(new RegisterVersionResponse());
        }
    }
}