﻿using System.Web.Http;
using System.Web.Http.Description;
using Curse.ClientService.Managers;
using Curse.Friends.BugsWebService.Contracts;
using Curse.Friends.MicroService;
using Curse.Friends.MicroService.Exceptions;
using Curse.Logging;

namespace Curse.Friends.BugsWebService.Controllers
{
    [RoutePrefix("feedback")]
    public class FeedbackController : MicroServiceController
    {
        [Route("")]
        [HttpPost]
        [ResponseType(typeof(void))]
        public IHttpActionResult Report(Feedback feedback)
        {
            try
            {
                feedback.Validate();
            }
            catch (RequestValidationException ex)
            {
                Logger.Warn("Failed to submit feedback", new {FailureReason = ex.ToSerializableObject(), feedback.ClientVersion, feedback.FeedbackType, feedback.Platform, feedback.Message});
                throw;
            }

            var reportingUserInfo = GetReportingUserInfo();            
            BugReportingManager.QueueFeedback(feedback, reportingUserInfo);
            return Ok();
        }

        private ReportingUserInfo GetReportingUserInfo()
        {
            if (Token.IsAnonymous)
            {
                return ReportingUserInfo.Default;
            }

            UserRegionInfo loggedInUser = null;
            try
            {
                loggedInUser = GetCurrentUserAndRegion();
            }
            catch { }

            if (loggedInUser != null && loggedInUser.User != null)
            {
                return new ReportingUserInfo
                {
                    CurseUserID = loggedInUser.User.UserID,
                    Username = loggedInUser.User.Username,
                    TwitchUserID = loggedInUser.User.TwitchID,
                    Email = loggedInUser.User.EmailAddress
                };
            }
            return ReportingUserInfo.Default;
        }
    }
}