﻿using System.Web.Http;
using Curse.Friends.MicroService;
using System.Web.Http.Description;
using Curse.Friends.BugsWebService.Contracts;
using Curse.Friends.Data;
using Curse.Friends.Data.Queues;

namespace Curse.Friends.BugsWebService.Controllers
{
    [RoutePrefix("user-reporting")]
    public class UserReportingController : MicroServiceController
    {
        [Route("")]
        [HttpPost]
        [ResponseType(typeof (void))]        
        public IHttpActionResult Report(UserReport report)
        {
            report.Validate();

            if (report.UserID == Token.UserID)
            {
                return BadRequest("You can't report yourself!");
            }           
            
            // Ensure that the target user exists
            var targetUser = UserRegion.GetByUserID(Token.UserID);

            if (targetUser == null)
            {
                return BadRequest("Unknown user!");
            }           

            // Queue this report off for tranmission to Leviathan
            UserReportWorker.Create(Token.UserID, report.Type, report.Reason, report.UserID, report.Description);

            return Ok();

        }
    }
}