﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;

namespace Curse.Friends.BugsWebService.Extensions
{
    public static class SqlDataReaderExtensions
    {
        public static T SafeGet<T>(this SqlDataReader reader, int ordinal)
        {
            if (reader.IsDBNull(ordinal))
            {
                return default(T);
            }

            var value = reader.GetValue(ordinal);

            if (value is T)
            {
                return (T) value;
            }
            return default(T);
        }
    }
}