﻿using Curse.ClientService.Managers;
using Curse.Friends.MicroService;
using Curse.Friends.Configuration;

namespace Curse.Friends.BugsWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.BugsWebService; }
        }

        protected override string ServiceDescription
        {
            get { return "The bugs service provides functionality for reporting bugs, feedback and feature requests."; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database | ConfigurationServices.Queue; }
        }

        protected override void CustomApplicationStartup()
        {
            BugReportingManager.Start();
        }

        protected override void CustomApplicationShutdown()
        {
            BugReportingManager.Stop();
        }
    }
}
