﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Web;
using Curse.Friends.BugsWebService.Configuration;

namespace Curse.Friends.BugsWebService.Models
{
    public class ClientCrashIncident
    {
        public int ReportID { get; set; }
        public int ClientVersionID { get; set; }
        public int UserID { get; set; }
        public byte[] IpAddress { get; set; }

        public ClientCrashIncident(int reportID, int clientVersionID, int userID, IPAddress ipAddress)
        {
            ReportID = reportID;
            ClientVersionID = clientVersionID;
            UserID = userID;
            IpAddress = ipAddress.GetAddressBytes();
        }

        private void Save(SqlConnection conn)
        {
            using (var cmd = conn.CreateCommand())
            {
                cmd.CommandText = "INSERT INTO [ClientCrashIncident] (ReportID, VersionID, DateCreated, UserID, IPAddress)"
                                  + " OUTPUT INSERTED.ID"
                                  + " VALUES(@ReportID, @VersionID, GETUTCDATE(), @UserID, @IPAddress)";
                cmd.Parameters.AddWithValue("@ReportID", ReportID);
                cmd.Parameters.AddWithValue("@VersionID", ClientVersionID);
                cmd.Parameters.AddWithValue("@UserID", UserID);
                cmd.Parameters.AddWithValue("@IPAddress", IpAddress);
                cmd.ExecuteNonQuery();
            }
        }

        public static void SaveToDatabase(int reportID, int clientVersionID, int userID, IPAddress ipAddress)
        {
            var crash = new ClientCrashIncident(reportID, clientVersionID, userID, ipAddress);
            using (var conn = new SqlConnection(BugsWebServiceConfiguration.Current.DatabaseConnectionString))
            {
                conn.Open();
                crash.Save(conn);
            }
        }
    }
}