﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using Curse.Friends.Enums;
using Curse.Friends.BugsWebService.Configuration;
using Curse.Logging;

namespace Curse.Friends.BugsWebService.Models
{
    public class ClientVersion
    {
        public static int? GetOrCreateVersion(string version, DevicePlatform platform)
        {

            // Check the database
            using (var conn = new SqlConnection(BugsWebServiceConfiguration.Current.DatabaseConnectionString))
            {
                conn.Open();

                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText =
                        "SELECT TOP 1 [ID] from [ClientVersion] where [VersionString] = @VersionString AND [Platform] = @Platform";
                    cmd.Parameters.AddWithValue("@VersionString", version);
                    cmd.Parameters.AddWithValue("@Platform", (int)platform);

                    using (var reader = cmd.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            return reader.GetInt32(0);
                        }

                        var newVersionID = CreateClientVersion(version, platform);

                        if (newVersionID > 0)
                        {
                            return newVersionID;
                        }

                        return null;
                    }
                }
            }
        }

        private static int CreateClientVersion(string version, DevicePlatform platform)
        {            
            // Check the database
            using (var conn = new SqlConnection(BugsWebServiceConfiguration.Current.DatabaseConnectionString))
            {
                conn.Open();

                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "INSERT INTO [ClientVersion]([Type], [VersionString], [Platform], [DateReleased]) OUTPUT INSERTED.ID VALUES(@Type, @VersionString, @Platform, GETUTCDATE())";
                    cmd.Parameters.AddWithValue("@Type", 1);
                    cmd.Parameters.AddWithValue("@VersionString", version);
                    cmd.Parameters.AddWithValue("@Platform", (int)platform);

                    return (int)cmd.ExecuteScalar();
                }
            }
            
        }

    }
}